/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.event;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.util.DateUtils;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.StringUtils;

class AntSystemLogBuildListener
implements BuildListener {
    private static final Logger logger = Logger.getLogger(AntSystemLogBuildListener.class.getName());
    private final int level;
    private long startTime;

    public AntSystemLogBuildListener(int level) {
        this.level = level;
    }

    public void buildStarted(BuildEvent buildEvent) {
        this.startTime = System.currentTimeMillis();
    }

    private static String throwableMessage(Throwable error, boolean verbose) {
        String msg2;
        String msg1;
        Throwable cause;
        StringBuilder m = new StringBuilder();
        while (error instanceof BuildException && (cause = error.getCause()) != null && (msg1 = error.toString()).endsWith(msg2 = cause.toString())) {
            m.append(msg1.substring(0, msg1.length() - msg2.length()));
            error = cause;
        }
        if (verbose || !(error instanceof BuildException)) {
            m.append(StringUtils.getStackTrace((Throwable)error));
        } else {
            m.append(error);
        }
        return m.toString();
    }

    public void buildFinished(BuildEvent event) {
        Throwable error = event.getException();
        if (error == null) {
            logger.info("BUILD SUCCESSFUL");
        } else {
            logger.severe("BUILD FAILED");
            logger.severe(AntSystemLogBuildListener.throwableMessage(error, 3 <= this.level));
        }
        logger.info("Total time: " + AntSystemLogBuildListener.formatTime(System.currentTimeMillis() - this.startTime));
    }

    public void targetStarted(BuildEvent event) {
        String targetName = event.getTarget().getName().trim();
        if (2 <= this.level && !targetName.equals("")) {
            logger.info(targetName + ":");
        }
    }

    public void targetFinished(BuildEvent event) {
    }

    public void taskStarted(BuildEvent event) {
    }

    public void taskFinished(BuildEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void messageLogged(BuildEvent event) {
        priority = event.getPriority();
        if (priority <= this.level) {
            if (event.getTask() != null) {
                label = "  [" + event.getTask().getTaskName() + "] ";
                r = null;
                try {
                    r = new BufferedReader(new StringReader(event.getMessage()));
                    while ((line = r.readLine()) != null) {
                        if (priority != 0) {
                            AntSystemLogBuildListener.logger.info(label + line);
                            continue;
                        }
                        AntSystemLogBuildListener.logger.severe(label + line);
                    }
                    ** if (r == null) goto lbl-1000
                }
                catch (IOException e) {
                    try {
                        AntSystemLogBuildListener.logger.severe(event.getMessage());
                        ** if (r == null) goto lbl-1000
                    }
                    catch (Throwable var6_7) {
                        if (r != null) {
                            FileUtils.close(r);
                        }
                        throw var6_7;
                    }
lbl-1000:
                    // 1 sources

                    {
                        FileUtils.close((Reader)r);
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                }
lbl-1000:
                // 1 sources

                {
                    FileUtils.close((Reader)r);
                }
lbl-1000:
                // 2 sources

                {
                }
            }
            ex = event.getException();
            if (4 <= this.level && ex != null) {
                AntSystemLogBuildListener.logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    private static String formatTime(long millis) {
        return DateUtils.formatElapsedTime((long)millis);
    }
}

